/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2000 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PSPlugin.h
//
//	Description:
//		PSPlugin class definition.
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#ifndef __PSPlugin_H__
#define __PSPlugin_H__

#include "PIDefines.h"
#include "PIAbout.h"
#ifndef __PIWin__
	#include <Dialogs.h>
#else
	#include <windows.h>
#endif

#ifdef __PIMac__
	#define HANDLE Handle
#endif


class PSPlugin {
private:
	HANDLE DLLInstance;
	PSPlugin(); // don't define this
	PSPlugin(PSPlugin&); // don't define this
	
protected:
	virtual void About(void) = 0;
	PSPlugin(HANDLE DLLInstance);
	~PSPlugin();

public:
	void HandleMessage(const short selector, void* record);
	HANDLE GetInstance() { return DLLInstance; }
};
#endif
// end PSPlugin.h
